function [t,x] = RK(f,T,x0,h)
  
  t = 0:h:T; 
  N = length(t);
  x = zeros(N,1);
  x(1)=x0; 
  
  for j=1:N-1 
    tt = t(j); 
    xx = x(j);
    K1 = f(tt,xx);
    K2 = f(tt+h/2,xx+h*K1/2); 
    K3 = f(tt+h,xx-h*K1+2*h*K2); 
    x(j+1) = x(j)+h*(K1+4*K2+K3)/6; 
  end
end